// CKMotionCNCDlg.cpp : implementation file
/*********************************************************************/
/*         Copyright (c) 2003-2006  DynoMotion Incorporated          */
/*********************************************************************/



#include "stdafx.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define FLAG_COLOR 0x808000

#define GCODE_FILES		"\\Data\\GFilesCNC.txt"

#define SLIDER_RANGE 100
#define OVERRIDE_MIN 0.50
#define OVERRIDE_MAX 2.0

#define STATUS_TIME 0.1 //sec


//static callbacks

void StraightTraverseCallback(double x, double y, double z, double a);

void ArcFeedCallback(double DesiredFeedRate_in_per_sec, 
				double first_end, double second_end, 
		        double first_axis, double second_axis, int rotation,
				double axis_end_point,
				double first_start, double second_start, double axis_start_point);

void StraightFeedCallback(double DesiredFeedRate_in_per_sec,
							   double x, double y, double z, double a);




/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()



void CKMotionCNCDlg::SaveOnExit(FILE * f)
{
	fprintf(f,"%d\n",m_Thread);
	fprintf(f,"%d\n",m_Simulate);
	fprintf(f,"%d\n",m_ShowMach);
	fprintf(f,"%d\n",m_StepSize);
	CDlgX::SaveOnExit(f);

	SaveFileNames();
	SaveConfig();
}

void CKMotionCNCDlg::RestoreOnStart(FILE * f)
{
	CString s;

	fscanf(f,"%d",&m_Thread);
	fscanf(f,"%d",&m_Simulate);
	fscanf(f,"%d",&m_ShowMach);
	fscanf(f,"%d",&m_StepSize);

	// also read in file names

	for (int i=0; i<N_USER_GCODE_FILES; i++)      // set to default names
	{
		s.Format("\\GCode Programs\\user%d.ngc",i+1);
		FileNames[i] = TheFrame->MainPath + s;
	}

	CString File = TheFrame->MainPath + GCODE_FILES;
	
	FILE *g = fopen(File.GetBuffer(0),"rt");
	
	if (!g)
	{
		CString s;
		s.Format("Error opening file %s\n"
				"Previous G Code Filenames", File.GetBuffer(MAX_PATH));

		::MessageBox(NULL,s, "KMotion", MB_ICONSTOP|MB_OK|MB_TOPMOST);
	}
	else
	{
		for (int i=0; i<N_USER_GCODE_FILES && !feof(g); i++)
		{
			fgets(FileNames[i].GetBuffer(MAX_PATH),MAX_PATH,g);
			FileNames[i].ReleaseBuffer();
			FileNames[i].Remove('\n');

			// check if there is no path specified, then add in default

			if (FileNames[i].Find('\\') == -1)
			{
				FileNames[i] = TheFrame->MainPathRoot + "\\GCode Programs\\" + FileNames[i];
			}
		}
		
		fclose(g);
	}

	LoadConfig();
	CDlgX::RestoreOnStart(f);
}


#define PERSIST_MCODE(x)			                            \
		INT(Interpreter.McodeActions[x].Action);			    \
		DOUBLE(Interpreter.McodeActions[x].dParams[0]);			\
		DOUBLE(Interpreter.McodeActions[x].dParams[1]);			\
		DOUBLE(Interpreter.McodeActions[x].dParams[2]);			\
		DOUBLE(Interpreter.McodeActions[x].dParams[3]);			\
		DOUBLE(Interpreter.McodeActions[x].dParams[4]);			\
		CHARS(Interpreter.McodeActions[x].String);		

	


int CKMotionCNCDlg::SaveLoadConfig(FILE *f, char *s, bool save)
{
	CString DefaultPath = TheFrame->MainPathRoot + "\\GCode Programs\\";

	CSTRING_PATH(m_SetupFile,DefaultPath);
	CSTRING_PATH(m_ToolFile,DefaultPath);
	CSTRING_PATH(m_GeoFile,DefaultPath);
	CSTRING(m_Button0);
	CSTRING(m_Button1);
	CSTRING(m_Button2);
	CSTRING(m_Button3);
	CSTRING(m_Button4);

	CSTRING(CommandHistory[0]);
	CSTRING(CommandHistory[1]);
	CSTRING(CommandHistory[2]);
	CSTRING(CommandHistory[3]);
	CSTRING(CommandHistory[4]);
	CSTRING(CommandHistory[5]);
	CSTRING(CommandHistory[6]);
	CSTRING(CommandHistory[7]);
	CSTRING(CommandHistory[8]);
	CSTRING(CommandHistory[9]);

	CSTRING(m_CommandString);

	DOUBLE(m_BreakAngle);
	DOUBLE(m_CollinearTol);
	DOUBLE(m_JogSpeed[0]);
	DOUBLE(m_JogSpeed[1]);
	DOUBLE(m_JogSpeed[2]);
	DOUBLE(m_JogSpeed[3]);
	DOUBLE(m_TPLookahead);
	DOUBLE(m_MaxAccelA);
	DOUBLE(m_MaxAccelX);
	DOUBLE(m_MaxAccelY);
	DOUBLE(m_MaxAccelZ);
	DOUBLE(m_MaxVelA);
	DOUBLE(m_MaxVelX);
	DOUBLE(m_MaxVelY);
	DOUBLE(m_MaxVelZ);
	DOUBLE(m_CountsPerInchA);
	DOUBLE(m_CountsPerInchX);
	DOUBLE(m_CountsPerInchY);
	DOUBLE(m_CountsPerInchZ);
	
	DOUBLE(m_Step0);
	DOUBLE(m_Step1);
	DOUBLE(m_Step2);
	DOUBLE(m_Step3);
	DOUBLE(m_Step4);
	DOUBLE(m_Step5);

	INT(m_ReverseRZ);

	PERSIST_MCODE(0);
	PERSIST_MCODE(1);
	PERSIST_MCODE(2);
	PERSIST_MCODE(3);
	PERSIST_MCODE(4);
	PERSIST_MCODE(5);
	PERSIST_MCODE(6);
	PERSIST_MCODE(7);
	PERSIST_MCODE(8);
	PERSIST_MCODE(9);
	PERSIST_MCODE(10);
	PERSIST_MCODE(11);
	PERSIST_MCODE(12);
	PERSIST_MCODE(13);
	PERSIST_MCODE(14);
	PERSIST_MCODE(15);
	return 0;
}


int CKMotionCNCDlg::SaveConfig()
{
	char s[81];
	CString Name = TheFrame->MainPath + "\\data\\GCodeConfigCNC.txt";

	FILE *f=fopen(Name.GetBuffer(0),"wb");
	
	if (!f)
	{
		CString cs;
		cs.Format("Error Opening Configuration File %s", Name.GetBuffer(0));
		TheFrame->MessageBox(cs,"Error",MB_ICONSTOP|MB_OK);
		return 1;
	}

	SaveLoadConfig(f, s, true);

	fclose(f);

	return 0;
}



int CKMotionCNCDlg::LoadConfig()
{
	char s[301];
	CString Name = TheFrame->MainPath + "\\data\\GCodeConfigCNC.txt";

	FILE *f=fopen(Name.GetBuffer(0),"rb");
	
	if (!f)
	{
		CString cs;
		cs.Format("Error Opening Configuration File %s", Name.GetBuffer(0));
		TheFrame->MessageBox(cs,"Error",MB_ICONSTOP|MB_OK);
		return 1;
	}

	while (!feof(f))
	{
		fgets(s,300,f);
		if (!feof(f))
		{
			SaveLoadConfig(f, s, false);
		}
	}

	fclose(f);

	return 0;
}




void CKMotionCNCDlg::SaveFileNames()
{
	CString DefaultPath = TheFrame->MainPathRoot + "\\GCode Programs\\";
	CString File = TheFrame->MainPath + GCODE_FILES;

	FILE *g = fopen(File.GetBuffer(0),"wt");
	
	if (!g)
	{
		CString s;
		s.Format("Error opening file %s\n"
				"To store Previous GCode Filenames", File.GetBuffer(MAX_PATH));
		::MessageBox(NULL,s, "KMotion", MB_ICONSTOP|MB_OK|MB_TOPMOST);
	}
	else
	{
		for (int i=0; i<N_USER_GCODE_FILES && !feof(g); i++)
		{
			// if the path is the default, and there is no other path specified, strip it off
			fprintf(g,"%s\n",StripPathMatch(FileNames[i],DefaultPath));
		}

		fclose(g);
	}
}


void CKMotionCNCDlg::LoadFile(int thread,bool ResetPosition)
{
	CString s;
	int fsize;
	CString DefaultPath = TheFrame->MainPathRoot + "\\GCode Programs\\";


	if (FileNames[thread].IsEmpty() || FileNames[thread] == DefaultPath)
	{
		// if filename for the thread is undefined
		// just set the editor empty

		s="";
	}
	else
	{
		FILE *f=fopen(FileNames[thread],"rb");

		if (!f)
		{
			s.Format("Error opening GCode file %s\n"
					"From Previous G Code Filenames", FileNames[thread]);
			::MessageBox(NULL,s, "KMotion", MB_ICONSTOP|MB_OK|MB_TOPMOST);

			s="";
			FileNames[thread]="";
		}
		else
		{
			fsize = fseek(f,0,SEEK_END);
			fsize = ftell(f);

			fseek(f,0,SEEK_SET);

			s="";
			
			if (fsize>0 && fread(s.GetBuffer(fsize),fsize,1,f) != 1)
			{
				AfxMessageBox("unable to open file");
			}
			else
			{
				fclose(f);
				s.ReleaseBuffer(fsize);
			}
		}
	}

    m_Editor.SetWindowText(s);
	m_Editor.EmptyUndoBuffer();
	m_Editor.SetSavePoint();
	DisplayedCurrentLine=-1;
	
	if (ResetPosition)
		OnRestart(); // reset to the beginning
	
	RefreshTitle();
	
	UpdateData(FALSE);
}


int CKMotionCNCDlg::SaveFile(int thread, bool ForceSave)
{
	CString s;

	// if the user isn't explicitly saving and the 
	// user hasn't changed anything then don't save

	if (!ForceSave && !m_Editor.GetModify()) return 0;

	// save the edit window

	m_Editor.GetWindowText(s);

	// if the file to save to is undefined and the editor is empty, forget it

	if (s.IsEmpty() && FileNames[thread].IsEmpty()) return 0;

	if (FileNames[thread].IsEmpty())
	{
		// if there is something to save, but the filename is undefined
		// ask user where to save it 

		return DoSaveAs(thread);
	}

	FILE *f=fopen(FileNames[thread],"wb");

	if (!f)
	{
		// if we couldn't open the file and the editor is
		// empty, then just forget it

		if (s.IsEmpty()) return 0;

		CString err;
		err.Format("Error saving GCode file %s\n"
				"From Previous GCode Filenames\r\r"
				"Use SaveAs to save to different directory or filename", FileNames[thread]);
		::MessageBox(NULL,err, "KMotion", MB_ICONSTOP|MB_OK|MB_TOPMOST);

		return 1;
	}
	else
	{
		if (s.GetLength()>0 && fwrite(s.GetBuffer(0),s.GetLength(),1,f) != 1)
		{
			AfxMessageBox("unable to write to file");
			return 1;
		}
		else
		{
			fclose(f);
		}
	}

	m_Editor.SetSavePoint();  // clear the Modified Flag
	RefreshTitle();

	return 0;
}

void CKMotionCNCDlg::DoDataExchange(CDataExchange* pDX)
{
	CDlgX::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CKMotionCNCDlg)
	DDX_Control(pDX, IDC_Command, m_Command);
	DDX_Control(pDX, IDC_tool, m_tool);
	DDX_Control(pDX, IDC_fixture, m_FixtureOffset);
	DDX_Control(pDX, IDC_Editor, m_Editor);
	DDX_Radio(pDX, IDC_Thread1, m_Thread);
	DDX_Check(pDX, IDC_Simulate, m_Simulate);
	DDX_Check(pDX, IDC_ShowMach, m_ShowMach);
	DDX_Control(pDX, IDC_FeedRateEdit, m_FeedRateEdit);
	DDX_Control(pDX, IDC_PosA, m_PosA);
	DDX_Control(pDX, IDC_PosZ, m_PosZ);
	DDX_Control(pDX, IDC_PosY, m_PosY);
	DDX_Control(pDX, IDC_PosX, m_PosX);
	DDX_Control(pDX, IDC_FeedSlider, m_FeedSlider);
	DDX_Control(pDX, IDC_Zplus2, m_Zplus2);
	DDX_Control(pDX, IDC_Zplus, m_Zplus);
	DDX_Control(pDX, IDC_ZplusStep, m_ZplusStep);
	DDX_Control(pDX, IDC_Zminus2, m_Zminus2);
	DDX_Control(pDX, IDC_Zminus, m_Zminus);
	DDX_Control(pDX, IDC_ZminusStep, m_ZminusStep);
	DDX_Control(pDX, IDC_Aplus2, m_Aplus2);
	DDX_Control(pDX, IDC_Aplus, m_Aplus);
	DDX_Control(pDX, IDC_AplusStep, m_AplusStep);
	DDX_Control(pDX, IDC_Aminus2, m_Aminus2);
	DDX_Control(pDX, IDC_Aminus, m_Aminus);
	DDX_Control(pDX, IDC_AminusStep, m_AminusStep);
	DDX_Control(pDX, IDC_Right2, m_Right2);
	DDX_Control(pDX, IDC_Right, m_Right);
	DDX_Control(pDX, IDC_RightStep, m_RightStep);
	DDX_Control(pDX, IDC_StopStep, m_StopStep);
	DDX_Control(pDX, IDC_Down2, m_Down2);
	DDX_Control(pDX, IDC_Down, m_Down);
	DDX_Control(pDX, IDC_DownStep, m_DownStep);
	DDX_Control(pDX, IDC_Up2, m_Up2);
	DDX_Control(pDX, IDC_Up, m_Up);
	DDX_Control(pDX, IDC_UpStep, m_UpStep);
	DDX_Control(pDX, IDC_Left2, m_Left2);
	DDX_Control(pDX, IDC_Left, m_Left);
	DDX_Control(pDX, IDC_LeftStep, m_LeftStep);
	DDX_Text(pDX, IDC_FeedRateEdit, m_FeedRateValue);
	DDV_MinMaxDouble(pDX, m_FeedRateValue, 0.5, 2.);
	DDX_CBString(pDX, IDC_Command, m_CommandString);
	DDV_MaxChars(pDX, m_CommandString, 256);
	DDX_Control(pDX, IDC_EmergencyStop, m_EmergencyStop);
	DDX_Radio(pDX, IDC_Step0, m_StepSize);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CKMotionCNCDlg, CDlgX)
	//{{AFX_MSG_MAP(CKMotionCNCDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_CTLCOLOR()
	ON_COMMAND(ID_F1, OnF1)
	ON_WM_TIMER()
	ON_WM_VSCROLL()
	ON_BN_CLICKED(IDC_FeedRateApply, OnFeedRateApply)
	ON_BN_CLICKED(IDC_EmergencyStop, OnEmergencyStop)
	ON_BN_CLICKED(IDC_ZeroAll, OnZeroAll)
	ON_BN_CLICKED(IDC_ZeroX, OnZeroX)
	ON_BN_CLICKED(IDC_ZeroY, OnZeroY)
	ON_BN_CLICKED(IDC_ZeroZ, OnZeroZ)
	ON_BN_CLICKED(IDC_ZeroA, OnZeroA)
	ON_BN_CLICKED(IDC_KMotion_HELP, OnIhelp)
	ON_BN_CLICKED(IDC_Thread1, OnThread1)
	ON_BN_CLICKED(IDC_Thread2, OnThread2)
	ON_BN_CLICKED(IDC_Thread3, OnThread3)
	ON_BN_CLICKED(IDC_Thread4, OnThread4)
	ON_BN_CLICKED(IDC_Thread5, OnThread5)
	ON_BN_CLICKED(IDC_Thread6, OnThread6)
	ON_BN_CLICKED(IDC_Thread7, OnThread7)
	ON_COMMAND(ID_SaveFile, OnSaveFile)
	ON_COMMAND(ID_New, OnNew)
	ON_COMMAND(ID_OpenFile, OnOpenFile)
	ON_COMMAND(ID_Execute, OnExecute)
	ON_COMMAND(ID_SaveAs, OnSaveAs)
	ON_COMMAND(ID_GCodeHalt, OnHalt)
	ON_COMMAND(ID_ToolSetup, OnToolSetup)
	ON_BN_CLICKED(IDC_ExecuteComplete, OnExecuteComplete)
	ON_COMMAND(ID_SingleStep, OnSingleStep)
	ON_COMMAND(ID_Restart, OnRestart)
	ON_UPDATE_COMMAND_UI(ID_GCodeHalt, OnUpdateHalt)
	ON_UPDATE_COMMAND_UI(ID_Execute, OnUpdateExecute)
	ON_UPDATE_COMMAND_UI(ID_Restart, OnUpdateRestart)
	ON_UPDATE_COMMAND_UI(ID_SingleStep, OnUpdateSingleStep)
	ON_COMMAND(ID_GView, OnGView)
	ON_BN_CLICKED(IDC_Simulate, OnSimulate)
	ON_BN_CLICKED(IDC_ShowMach, OnShowMach)
	ON_CBN_DROPDOWN(IDC_fixture, OnDropdownfixture)
	ON_CBN_CLOSEUP(IDC_fixture, OnCloseupfixture)
	ON_WM_CLOSE()
	ON_BN_CLICKED(IDC_Send, OnSend)
	ON_CBN_DROPDOWN(IDC_Command, OnDropdownCommand)
	ON_CBN_CLOSEUP(IDC_Command, OnCloseupCommand)
	ON_WM_CREATE()
	ON_WM_SHOWWINDOW()
	ON_BN_CLICKED(IDC_But0, OnBut0)
	ON_BN_CLICKED(IDC_But1, OnBut1)
	ON_BN_CLICKED(IDC_But2, OnBut2)
	ON_BN_CLICKED(IDC_But3, OnBut3)
	ON_BN_CLICKED(IDC_But4, OnBut4)
	ON_BN_CLICKED(IDC_Measure, OnMeasure)
	ON_BN_CLICKED(IDC_Step0, OnStep0)
	ON_BN_CLICKED(IDC_Step1, OnStep1)
	ON_BN_CLICKED(IDC_Step2, OnStep2)
	ON_BN_CLICKED(IDC_Step3, OnStep3)
	ON_BN_CLICKED(IDC_Step4, OnStep4)
	ON_BN_CLICKED(IDC_Step5, OnStep5)
	ON_BN_CLICKED(IDC_SetX, OnSetX)
	ON_BN_CLICKED(IDC_SetY, OnSetY)
	ON_BN_CLICKED(IDC_SetZ, OnSetZ)
	ON_BN_CLICKED(IDC_SetA, OnSetA)
	ON_BN_CLICKED(IDC_StopStep, OnStopStep)
	ON_BN_CLICKED(IDC_mm, Onmm)
	ON_BN_CLICKED(IDC_inch, Oninch)
	ON_WM_SIZE()
	ON_BN_CLICKED(IDC_Abs, OnAbs)
	ON_BN_CLICKED(IDC_Rel, OnRel)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()



/////////////////////////////////////////////////////////////////////////////
//  message handlers



void CKMotionCNCDlg::OnIhelp() 
{
	TheFrame->HelpDlg.Show("KMotionCNC\\KMotionCNC.htm");
}



void CKMotionCNCDlg::OnThread1() 
{
	ThreadChanged();
}

void CKMotionCNCDlg::OnThread2() 
{
	ThreadChanged();
}

void CKMotionCNCDlg::OnThread3() 
{
	ThreadChanged();
}

void CKMotionCNCDlg::OnThread4() 
{
	ThreadChanged();
}

void CKMotionCNCDlg::OnThread5() 
{
	ThreadChanged();
}

void CKMotionCNCDlg::OnThread6() 
{
	ThreadChanged();
}

void CKMotionCNCDlg::OnThread7() 
{
	ThreadChanged();
}

void CKMotionCNCDlg::ThreadChanged()
{
	int PrevThread=m_Thread;
	UpdateData(TRUE);  // save the editor box

	if (SaveFile(PrevThread,false)) // don't force the save
	{
		// for some reason can't save the previous file
		// switch back to this previous thread number

		m_Thread=PrevThread;
		UpdateData(false);
		return;
	}

	LoadFile(m_Thread,false);
}

void CKMotionCNCDlg::OnSaveFile() 
{
	SaveFile(m_Thread, true); // force the save
}

void CKMotionCNCDlg::OnNew() 
{
	CString s;
	
	s.Format("\\GCode Programs\\user%d.ngc",m_Thread+1);
	CString File = TheFrame->MainPathRoot + s;


	int answer = AfxMessageBox("Overwrite File:"+File+" ?",MB_YESNO);

	if (answer != IDYES) return;

    m_Editor.SetWindowText("");

	FileNames[m_Thread] = File;

	RefreshTitle();
	
	UpdateData(FALSE);

	SaveFile(m_Thread, true); // force the save
}

void CKMotionCNCDlg::OnOpenFile() 
{
	CString s;
	
	CFileDialog FileDlg (TRUE, ".ngc", NULL, 
		OFN_HIDEREADONLY | OFN_FILEMUSTEXIST, 
		"GCode Files (*.ngc)|*.ngc|All Files (*.*)|*.*||");

	FileDlg.m_ofn.lpstrInitialDir = CurrentDirectory;

	if (FileDlg.DoModal() == IDOK)
	{
		FileNames[m_Thread] = FileDlg.GetPathName();
		LoadFile(m_Thread,true);
		GetCurrentDirectory(MAX_PATH,CurrentDirectory.GetBufferSetLength(MAX_PATH));
		CurrentDirectory.ReleaseBuffer();
	}
}


void CKMotionCNCDlg::OnSaveAs() 
{
	DoSaveAs(m_Thread);
}


int CKMotionCNCDlg::DoSaveAs(int thread) 
{
	CString NoFile;

	CFileDialog FileDlg (FALSE, ".ngc", FileNames[thread], 
		OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, 
		"GCode Files (*.ngc)|*.ngc|All Files (*.*)|*.*||");

	// check if the last filename exists, if not
	// don't try to select it otherwise the file dialog fails

	FILE *f=NULL;
	
	if (!FileNames[thread].IsEmpty())
		f=fopen(FileNames[thread],"r");

	if (f)
	{
		fclose(f);
	}
	else
	{
		FileDlg.m_ofn.lpstrFile=NoFile.GetBuffer(MAX_PATH);
	}
	
	if (FileDlg.DoModal() == IDOK)
	{
		FileNames[thread] = FileDlg.GetPathName();
		SaveFile(thread, true);  // force the save
	}
	else
	{
		return 1;
	}
	return 0;
}



void CKMotionCNCDlg::RefreshTitle() 
{
	// no need, timer does it all the time
}


void CKMotionCNCDlg::OnExecuteComplete() 
{
	if (m_exitcode)
	{
		GetDlgItem(IDC_Editor)->SetFocus();
	}
}



void CompleteCallback(int status, int line_no, const char *err)
{
	CKMotionCNCDlg *p=&TheFrame->GCodeDlg;

	p->m_ErrorOutput=err;
	p->m_exitcode=status;

	if (p->m_ThreadThatWasLaunched>=0)
		p->GCodeThreadActive[p->m_ThreadThatWasLaunched]=false;

	if (status)
	{
		p->GCodeMutex->Lock();
		p->m_ErrorOutput=err;
		p->GCodeMutex->Unlock();
		
		// we know what line number
		// mark it in the edit cell

		if (p->m_ThreadThatWasLaunched>=0)
			p->ThreadHadError[p->m_ThreadThatWasLaunched]=true;

		if (!TheFrame->GCodeDlg.ShuttingDownApplication)
			AfxMessageBox("G Code Error\r\r" + p->m_ErrorOutput);
	}
	else
	{
		if (p->m_ThreadThatWasLaunched>=0)
		{
			p->ThreadHadError[p->m_ThreadThatWasLaunched]=false;
			p->CurrentLine[p->m_ThreadThatWasLaunched]=line_no;
		}
	}
	
	p->ThreadIsExecuting=false;

	// post message so GUI thread updates screens

	if (p->m_hWnd)
		p->PostMessage(WM_COMMAND,IDC_ExecuteComplete,0);
}

void StatusCallback(int line_no, const char *msg)
{
	CKMotionCNCDlg *p=&TheFrame->GCodeDlg;

	p->GCodeMutex->Lock();

	if (p->m_ThreadThatWasLaunched>=0)
		p->CurrentLine[p->m_ThreadThatWasLaunched]=line_no;

	p->GCodeMutex->Unlock();
}



void CKMotionCNCDlg::OnExecute() 
{
	if (SaveFile(m_Thread,false)) return;  // don't force the save
	m_ThreadThatWasLaunched=m_Thread;
	if (LaunchExecution(FileNames[m_Thread],CurrentLine[m_Thread],-1)) return;
	GCodeThreadActive[m_Thread]=1;
}

void CKMotionCNCDlg::OnSingleStep() 
{
	if (!ThreadIsExecuting)
	{
		if (SaveFile(m_Thread,false)) return;  // don't force the save
		m_ThreadThatWasLaunched=m_Thread;
		if (LaunchExecution(FileNames[m_Thread],CurrentLine[m_Thread],CurrentLine[m_Thread])) return;
		GCodeThreadActive[m_Thread]=1;
	}
}

void CKMotionCNCDlg::OnRestart() 
{
	ThreadHadError[m_Thread]=false;
	CurrentLine[m_Thread]=0;
}


int CKMotionCNCDlg::LaunchExecution(CString InFile,int begin, int end)
{
	if (InFile.IsEmpty())
	{
		AfxMessageBox("Invalid Filename Specified");
		return 1;
	}

	Interpreter.CoordMotion.SetStraightTraverseCallback(StraightTraverseCallback);
	Interpreter.CoordMotion.SetStraightFeedCallback(StraightFeedCallback);
	Interpreter.CoordMotion.SetArcFeedCallback(ArcFeedCallback);

	Interpreter.CoordMotion.m_Simulate = (m_Simulate==0) ? false : true;

	SetMotionParams();

	ThreadIsExecuting=true;

	if (begin==0 && m_ThreadThatWasLaunched!=-1)
	{
		TheFrame->GViewDlg.ClearPaths();
	}


//	Interpreter.Interpret(board,InFile,begin,end,(begin==0 && m_ThreadThatWasLaunched!=-1),StatusCallback,CompleteCallback);
	Interpreter.Interpret(board,InFile,begin,end,false,StatusCallback,CompleteCallback);
	
	return 0;
}

void CKMotionCNCDlg::SetMotionParams()
{
	MOTION_PARAMS *p=Interpreter.GetMotionParams();

	p->BreakAngle = m_BreakAngle;
	p->CollinearTol = m_CollinearTol;
	p->TPLookahead = m_TPLookahead;
	p->MaxAccelX = m_MaxAccelX;
	p->MaxAccelY = m_MaxAccelY;
	p->MaxAccelZ = m_MaxAccelZ;
	p->MaxAccelA = m_MaxAccelA;
	p->MaxVelX = m_MaxVelX;
	p->MaxVelY = m_MaxVelY;
	p->MaxVelZ = m_MaxVelZ;
	p->MaxVelA = m_MaxVelA;
	p->CountsPerInchX = m_CountsPerInchX;
	p->CountsPerInchY = m_CountsPerInchY;
	p->CountsPerInchZ = m_CountsPerInchZ;
	p->CountsPerInchA = m_CountsPerInchA;
	strcpy(Interpreter.ToolFile,m_ToolFile);
	strcpy(Interpreter.SetupFile,m_SetupFile);
	strcpy(Interpreter.GeoFile,m_GeoFile);
}



BOOL CKMotionCNCDlg::OnInitDialog() 
{
	int result,i;

	CDialog::OnInitDialog(); // bypass CDlgX Init Dialog for Modal Dialogs like this

	m_Editor.SetupForGCode();

	for (i=0; i<N_USER_GCODE_FILES; i++)
	{
		DisplayedThreadStat[i]=-1;     // set all undefined
		GCodeThreadActive[i]=0;
	}

	DisplayedCurrentLine=-1;

	if (!GreenBrush)
	{
		GreenBrush = new CBrush;
		GreenBrush->CreateSolidBrush(0xff00); 
	}
	
	if (m_Thread <0 || m_Thread >= N_USER_GCODE_FILES) m_Thread = 0;
	LoadFile(m_Thread,false);

	RefreshTitle();

	if (CurrentDirectory.IsEmpty())
	{
		CurrentDirectory = TheFrame->MainPathRoot + GCODE_SUB_DIR;
	}



	m_EmergencyStop.LoadBitmaps(IDB_EmergencyStop,0,0);
	m_LeftStep.LoadBitmaps(IDB_LeftStep,0,0);
	m_Left.LoadBitmaps(IDB_Left,0,0);
	m_Left2.LoadBitmaps(IDB_Left2,0,0);
	m_RightStep.LoadBitmaps(IDB_LeftStep,0,0);
	m_Right.LoadBitmaps(IDB_Right,0,0);
	m_Right2.LoadBitmaps(IDB_Right2,0,0);
	
	m_DownStep.LoadBitmaps(IDB_UpStep,0,0);
	m_Down.LoadBitmaps(IDB_Down,0,0);
	m_Down2.LoadBitmaps(IDB_Down2,0,0);
	m_UpStep.LoadBitmaps(IDB_UpStep,0,0);
	m_Up.LoadBitmaps(IDB_Up,0,0);
	m_Up2.LoadBitmaps(IDB_Up2,0,0);

	m_ZplusStep.LoadBitmaps(IDB_UpStep,0,0);
	m_Zplus.LoadBitmaps(IDB_Up,0,0);
	m_Zplus2.LoadBitmaps(IDB_Up2,0,0);
	m_ZminusStep.LoadBitmaps(IDB_UpStep,0,0);
	m_Zminus.LoadBitmaps(IDB_Down,0,0);
	m_Zminus2.LoadBitmaps(IDB_Down2,0,0);

	m_AminusStep.LoadBitmaps(IDB_LeftStep,0,0);
	m_Aminus.LoadBitmaps(IDB_Left,0,0);
	m_Aminus2.LoadBitmaps(IDB_Left2,0,0);
	m_AplusStep.LoadBitmaps(IDB_LeftStep,0,0);
	m_Aplus.LoadBitmaps(IDB_Right,0,0);
	m_Aplus2.LoadBitmaps(IDB_Right2,0,0);

	m_StopStep.LoadBitmaps(IDB_StopStep,0,0);


	m_RightStep.Init	(this, 0, 1,0.5,true);
	m_Right.Init		(this, 0, 1,0.5,false);
	m_Right2.Init		(this, 0, 1,1.0,false);
	m_LeftStep.Init		(this, 0,-1,0.5,true);
	m_Left.Init			(this, 0,-1,0.5,false);
	m_Left2.Init		(this, 0,-1,1.0,false);
	
	m_UpStep.Init		(this, 1, 1,0.5,true);
	m_Up.Init			(this, 1, 1,0.5,false);
	m_Up2.Init			(this, 1, 1,1.0,false);
	m_DownStep.Init		(this, 1,-1,0.5,true);
	m_Down.Init			(this, 1,-1,0.5,false);
	m_Down2.Init		(this, 1,-1,1.0,false);

	m_ZplusStep.Init	(this, 2, 1,0.5,true);
	m_Zplus.Init		(this, 2, 1,0.5,false);
	m_Zplus2.Init		(this, 2, 1,1.0,false);
	m_ZminusStep.Init	(this, 2,-1,0.5,true);
	m_Zminus.Init		(this, 2,-1,0.5,false);
	m_Zminus2.Init		(this, 2,-1,1.0,false);

	m_AplusStep.Init	(this, 3, 1,0.5,true);
	m_Aplus.Init		(this, 3, 1,0.5,false);
	m_Aplus2.Init		(this, 3, 1,1.0,false);
	m_AminusStep.Init	(this, 3,-1,0.5,true);
	m_Aminus.Init		(this, 3,-1,0.5,false);
	m_Aminus2.Init		(this, 3,-1,1.0,false);



	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	m_hIcon = AfxGetApp()->LoadIcon(IDI_KMotionCNC16);
	SetIcon(m_hIcon,FALSE);
	m_hIcon = AfxGetApp()->LoadIcon(IDI_KMotionCNC32);
	SetIcon(m_hIcon,TRUE);
	

	
	m_GCodeTools = new CDlgToolBar;

	// Create toolbar at the top of the dialog window
	if (m_GCodeTools->Create(this))
	{
	    result = m_GCodeTools->LoadToolBar(IDR_GCodeBar);
	}      
	
	m_GCodeTools->SetBarStyle(m_GCodeTools->GetBarStyle() |
		CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC);


	// And position the control bars
	RepositionBars(AFX_IDW_CONTROLBAR_FIRST, AFX_IDW_CONTROLBAR_LAST, 0);


	m_FeedSlider.SetRange(OVERRIDE_MIN,OVERRIDE_MAX,100);
	m_FeedSlider.SetTicFreq(5);
	m_FeedSlider.SetPos(1.0);

	SetTimer(0,(int)(STATUS_TIME*1000),NULL);

	CRect rcClientStart;
	CRect rcClientNow;
	GetClientRect(rcClientStart);
	
	// To reposition and resize the control bar
	
	CRect rcWindow;
	CRect rcWindowScint;
	m_GCodeTools->GetWindowRect(rcWindow);
	m_Editor.GetWindowRect(rcWindowScint);
	int width=rcWindowScint.right-rcWindowScint.left;
	int height=rcWindow.bottom-rcWindow.top;
	
	rcWindow.left = rcWindowScint.left+10;
	rcWindow.bottom = rcWindowScint.top;
	rcWindow.top = rcWindow.bottom-height;
	rcWindow.right = rcWindow.left+width;

	ScreenToClient(rcWindow);

	m_GCodeTools->MoveWindow(rcWindow, FALSE);	
	
	m_Editor.SetupForGCode();

	FillComboWithCount(1,99,&m_tool);
	FillComboWithCountFixture(1,9,&m_FixtureOffset);

	SetUserButtons();

	SetMotionParams();

	Interpreter.ReadSetupFile();

	EnableToolTips();

	Interpreter.CoordMotion.Kinematics->ReadGeoTable(m_GeoFile);

	SetStepSizes();

	return TRUE;  // return TRUE  unless you set the focus to a control
}
	
void StraightTraverseCallback(double x, double y, double z, double a)
{
	TheFrame->GViewDlg.m_view.OpenGLMutex->Lock();
	TheFrame->GViewDlg.m_Path->AddVertex(new CVertex3d(x,y,z,TheFrame->GCodeDlg.m_ColorTraverse));
	TheFrame->GViewDlg.m_Path->SetModified();
	TheFrame->GViewDlg.m_view.OpenGLMutex->Unlock();
}
	
void StraightFeedCallback(double DesiredFeedRate_in_per_sec,
							   double x, double y, double z, double a)

{
	TheFrame->GViewDlg.m_view.OpenGLMutex->Lock();
	TheFrame->GViewDlg.m_Path->AddVertex(new CVertex3d(x,y,z,TheFrame->GCodeDlg.m_ColorFeed));
	TheFrame->GViewDlg.m_Path->SetModified();
	TheFrame->GViewDlg.m_view.OpenGLMutex->Unlock();
}

#define N_SEG 50.0

void ArcFeedCallback(double DesiredFeedRate_in_per_sec, 
				double first_end, double second_end, 
		        double first_axis, double second_axis, int rotation,
				double axis_end_point,
				double first_start, double second_start, double axis_start_point)
{
	double invd, radius, theta0, theta1, d_theta, dxy, theta;
	double dx = first_start-first_axis;
	double dy = second_start-second_axis;
	double dz = axis_end_point-axis_start_point;
	double sum2,x,y,z;
	int n_segs,i;
	
	radius = sqrt(dx*dx + dy*dy); 

	theta0 = atan2(second_start-second_axis,first_start-first_axis);
	theta1 = atan2(second_end-second_axis,first_end-first_axis);  
						
	d_theta =  theta1 - theta0;        

	if (rotation)
	{
		if (d_theta < 0.0f) d_theta+=TWO_PI; // CCW delta should be +  
	}
	else
	{
		if (d_theta > 0.0f) d_theta-=TWO_PI;  // CW delta should be -
	}
	
	dxy = d_theta * radius;  // path length along circle                                   
	
	sum2 = dxy*dxy + dz*dz;
						  
	if (sum2>0.0f)                      
		invd = 1.0f/sqrt(sum2); // inverse total length
	else
		sum2=0.0f;

	// compute number of line segments to achieve desired tolerance
	//
	//
	// given tolerance T and Radius R the largest angle of a segment is:
	//
	// max_theta = acos(1 - T/radius)
	// but actually for now just do 50 sided circles

	n_segs = (int)fabs(N_SEG * d_theta/TWO_PI) + 1;

	for (i=1; i<=n_segs; i++)
	{
		theta = theta0 + (double) i * d_theta/n_segs;

		x = radius * cos(theta) + first_axis;
		y = radius * sin(theta) + second_axis;
		z = (double) i * dz/n_segs + axis_start_point;
		TheFrame->GViewDlg.m_Path->AddVertex(new CVertex3d(x,y,z,TheFrame->GCodeDlg.m_ColorFeed));
	}
	TheFrame->GViewDlg.m_Path->SetModified();
}
	
void CKMotionCNCDlg::OnHalt() 
{
	Interpreter.Halt();
}



HBRUSH CKMotionCNCDlg::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor) 
{
	HBRUSH hbr = CDlgX::OnCtlColor(pDC, pWnd, nCtlColor);
	
	for (int i=0; i<N_USER_GCODE_FILES; i++)
	{
		if (pWnd->m_hWnd==GetDlgItem(NumberToThreadID(i))->m_hWnd)
		{
			DisplayedThreadStat[i] = GCodeThreadActive[i];
			
			if (DisplayedThreadStat[i])
			{
				pDC->SetBkColor(0xff00);
				return *GreenBrush;

			}
			else
			{
				return hbr;
			}
		}
	}
	return hbr;
}


void CKMotionCNCDlg::OnTimer(UINT nIDEvent) 
{
	int result;

	if (nIDEvent==2)
	{
		*SaveUserCommandVar=SaveUserCommand;
		SaveUserCommandCombo->SetWindowText(SaveUserCommand);
		SaveUserCommandCombo->SetEditSel(SaveUserCommand.GetLength(),SaveUserCommand.GetLength());
		KillTimer(2);
		CDlgX::OnTimer(nIDEvent);
	}
	else
	{
		if (ReadStatus)
		{
			result=TheFrame->KMotionDLL.WaitToken(board,false,100.0);

			if (result == KMOTION_LOCKED)
			{
				// Note only service the console 
				// after we have the token so we
				// are sure of no getting blocked

				TheFrame->KMotionDLL.ServiceConsole(board);
			
				// upload bulk status

				if (GetStatus())
				{
					Interpreter.Abort();

					// error reading status
					TheFrame->KMotionDLL.Failed(board);
				}
				
				TheFrame->KMotionDLL.ReleaseToken(board);

				UpdateScreen(true);
			}
			else
				UpdateScreen(false);


			CString NewTitle;

			if (result != KMOTION_NOT_CONNECTED)
				NewTitle = 	"KMotionCNC - Connected - " + FileNames[m_Thread];
			else
				NewTitle = 	"KMotionCNC - Disconnected - " + FileNames[m_Thread];

			if (LastTitleText != NewTitle)
			{
				LastTitleText = NewTitle;
				SetWindowText(LastTitleText);
			}
		}

		DoJoyStick();


		int ThreadStat;
		
		// check if thread status is different from displayed

		for (int i=0; i<N_USER_GCODE_FILES; i++)
		{
			ThreadStat = GCodeThreadActive[i];
			if (DisplayedThreadStat[i] != ThreadStat)
				GetDlgItem(NumberToThreadID(i))->InvalidateRect(NULL);
		}

		
		GCodeMutex->Unlock();

		if (CurrentLine[m_Thread]    != DisplayedCurrentLine ||
			ThreadHadError[m_Thread] != DisplayedThreadHadError)
		{
			m_Editor.MarkerDeleteAll(0);

			if (ThreadHadError[m_Thread])
			{
				m_Editor.MarkerSetFore(0,0x0000ff);
				m_Editor.MarkerSetBack(0,0x0000ff);
			}
			else
			{
				m_Editor.MarkerSetFore(0,FLAG_COLOR);
				m_Editor.MarkerSetBack(0,FLAG_COLOR);
			}
			
			m_Editor.MarkerDefine(0,SC_MARK_ARROW);
			m_Editor.MarkerAdd(CurrentLine[m_Thread], 0);
			m_Editor.GotoLine(CurrentLine[m_Thread]);

			DisplayedCurrentLine=CurrentLine[m_Thread];
			DisplayedThreadHadError=ThreadHadError[m_Thread];
		}
		else
		{
			// verify that the marker is really there
			//
			// if it isn't the user probably added/deleted some lines

			if (m_Editor.MarkerGet(DisplayedCurrentLine) != 1)
			{
				// see if it moved

				int line = m_Editor.MarkerNext(0,1);

				if (line == -1)
				{
					// not found, put it at the end

					DisplayedCurrentLine = CurrentLine[m_Thread] = m_Editor.GetLineCount()-1;

					m_Editor.MarkerDeleteAll(0);

					ThreadHadError[m_Thread]=false;  // lines were deleted remove error marker

					m_Editor.MarkerSetFore(0,FLAG_COLOR);
					m_Editor.MarkerSetBack(0,FLAG_COLOR);
					m_Editor.MarkerDefine(0,SC_MARK_ARROW);
					m_Editor.MarkerAdd(CurrentLine[m_Thread], 0);
				}
				else
				{
					// it was found, update Current line
					DisplayedCurrentLine = CurrentLine[m_Thread] = line;
				}
			}
		}
	}

	CDlgX::OnTimer(nIDEvent);
}

// converts 0 based index to thread ID

int CKMotionCNCDlg::NumberToThreadID(int i) 
{
	switch (i)
	{
	case 0 : return IDC_Thread1;
	case 1 : return IDC_Thread2;
	case 2 : return IDC_Thread3;
	case 3 : return IDC_Thread4;
	case 4 : return IDC_Thread5;
	case 5 : return IDC_Thread6;
	case 6 : return IDC_Thread7;
	}

	return 0;
}

void CKMotionCNCDlg::OnToolSetup() 
{
	CToolFile ToolSetupDlg;

	ToolSetupDlg.m_ToolFile = m_ToolFile;
	ToolSetupDlg.m_SetupFile = m_SetupFile;
	ToolSetupDlg.m_GeoFile = m_GeoFile;
	ToolSetupDlg.m_MaxAccelA = m_MaxAccelA;
	ToolSetupDlg.m_BreakAngle = m_BreakAngle;
	ToolSetupDlg.m_CollinearTol = m_CollinearTol;
	ToolSetupDlg.m_ReverseRZ = m_ReverseRZ;
	ToolSetupDlg.m_JogSpeedX = m_JogSpeed[0];
	ToolSetupDlg.m_JogSpeedY = m_JogSpeed[1];
	ToolSetupDlg.m_JogSpeedZ = m_JogSpeed[2];
	ToolSetupDlg.m_JogSpeedA = m_JogSpeed[3];
	ToolSetupDlg.m_Step0 = m_Step0;
	ToolSetupDlg.m_Step1 = m_Step1;
	ToolSetupDlg.m_Step2 = m_Step2;
	ToolSetupDlg.m_Step3 = m_Step3;
	ToolSetupDlg.m_Step4 = m_Step4;
	ToolSetupDlg.m_Step5 = m_Step5;
	ToolSetupDlg.m_TPLookahead = m_TPLookahead;
	ToolSetupDlg.m_MaxAccelX = m_MaxAccelX;
	ToolSetupDlg.m_MaxAccelY = m_MaxAccelY;
	ToolSetupDlg.m_MaxAccelZ = m_MaxAccelZ;
	ToolSetupDlg.m_MaxVelA = m_MaxVelA;
	ToolSetupDlg.m_MaxVelX = m_MaxVelX;
	ToolSetupDlg.m_MaxVelY = m_MaxVelY;
	ToolSetupDlg.m_MaxVelZ = m_MaxVelZ;
	ToolSetupDlg.m_CountsPerInchA = m_CountsPerInchA;
	ToolSetupDlg.m_CountsPerInchX = m_CountsPerInchX;
	ToolSetupDlg.m_CountsPerInchY = m_CountsPerInchY;
	ToolSetupDlg.m_CountsPerInchZ = m_CountsPerInchZ;
	ToolSetupDlg.m_Button0 = m_Button0;
	ToolSetupDlg.m_Button1 = m_Button1;
	ToolSetupDlg.m_Button2 = m_Button2;
	ToolSetupDlg.m_Button3 = m_Button3;
	ToolSetupDlg.m_Button4 = m_Button4;
	memcpy(ToolSetupDlg.McodeActions,Interpreter.McodeActions,sizeof(Interpreter.McodeActions));

	if (ToolSetupDlg.DoModal() == IDOK)
	{
		m_ToolFile  = ToolSetupDlg.m_ToolFile;
		m_SetupFile = ToolSetupDlg.m_SetupFile;
		m_GeoFile = ToolSetupDlg.m_GeoFile;
		m_MaxAccelA = ToolSetupDlg.m_MaxAccelA;
		m_BreakAngle = ToolSetupDlg.m_BreakAngle;
		m_CollinearTol = ToolSetupDlg.m_CollinearTol;
		m_ReverseRZ = ToolSetupDlg.m_ReverseRZ;
		m_JogSpeed[0] = ToolSetupDlg.m_JogSpeedX;
		m_JogSpeed[1] = ToolSetupDlg.m_JogSpeedY;
		m_JogSpeed[2] = ToolSetupDlg.m_JogSpeedZ;
		m_JogSpeed[3] = ToolSetupDlg.m_JogSpeedA;
		m_Step0 = ToolSetupDlg.m_Step0;
		m_Step1 = ToolSetupDlg.m_Step1;
		m_Step2 = ToolSetupDlg.m_Step2;
		m_Step3 = ToolSetupDlg.m_Step3;
		m_Step4 = ToolSetupDlg.m_Step4;
		m_Step5 = ToolSetupDlg.m_Step5;
		m_TPLookahead = ToolSetupDlg.m_TPLookahead;
		m_MaxAccelX = ToolSetupDlg.m_MaxAccelX;
		m_MaxAccelY = ToolSetupDlg.m_MaxAccelY;
		m_MaxAccelZ = ToolSetupDlg.m_MaxAccelZ;
		m_MaxVelA = ToolSetupDlg.m_MaxVelA;
		m_MaxVelX = ToolSetupDlg.m_MaxVelX;
		m_MaxVelY = ToolSetupDlg.m_MaxVelY;
		m_MaxVelZ = ToolSetupDlg.m_MaxVelZ;
		m_CountsPerInchA = ToolSetupDlg.m_CountsPerInchA;
		m_CountsPerInchX = ToolSetupDlg.m_CountsPerInchX;
		m_CountsPerInchY = ToolSetupDlg.m_CountsPerInchY;
		m_CountsPerInchZ = ToolSetupDlg.m_CountsPerInchZ;
		m_Button0 = ToolSetupDlg.m_Button0;
		m_Button1 = ToolSetupDlg.m_Button1;
		m_Button2 = ToolSetupDlg.m_Button2;
		m_Button3 = ToolSetupDlg.m_Button3;
		m_Button4 = ToolSetupDlg.m_Button4;
		memcpy(Interpreter.McodeActions,ToolSetupDlg.McodeActions,sizeof(Interpreter.McodeActions));
	
		SetMotionParams();

		Interpreter.CoordMotion.Kinematics->ReadGeoTable(m_GeoFile);
		
		SetUserButtons();
		SetStepSizes();
		SaveConfig();
	}
}



void CKMotionCNCDlg::OnUpdateHalt(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(ThreadIsExecuting && !Interpreter.GetHalt());
}


void CKMotionCNCDlg::OnUpdateExecute(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!ThreadIsExecuting);
	m_Zplus2.EnableWindow(!ThreadIsExecuting);
	m_Zplus.EnableWindow(!ThreadIsExecuting);
	m_ZplusStep.EnableWindow(!ThreadIsExecuting);
	m_Zminus2.EnableWindow(!ThreadIsExecuting);
	m_Zminus.EnableWindow(!ThreadIsExecuting);
	m_ZminusStep.EnableWindow(!ThreadIsExecuting);
	m_Aplus2.EnableWindow(!ThreadIsExecuting);
	m_Aplus.EnableWindow(!ThreadIsExecuting);
	m_AplusStep.EnableWindow(!ThreadIsExecuting);
	m_Aminus2.EnableWindow(!ThreadIsExecuting);
	m_Aminus.EnableWindow(!ThreadIsExecuting);
	m_AminusStep.EnableWindow(!ThreadIsExecuting);
	m_Right2.EnableWindow(!ThreadIsExecuting);
	m_Right.EnableWindow(!ThreadIsExecuting);
	m_RightStep.EnableWindow(!ThreadIsExecuting);
	m_Down2.EnableWindow(!ThreadIsExecuting);
	m_Down.EnableWindow(!ThreadIsExecuting);
	m_DownStep.EnableWindow(!ThreadIsExecuting);
	m_Up2.EnableWindow(!ThreadIsExecuting);
	m_Up.EnableWindow(!ThreadIsExecuting);
	m_UpStep.EnableWindow(!ThreadIsExecuting);
	m_Left2.EnableWindow(!ThreadIsExecuting);
	m_Left.EnableWindow(!ThreadIsExecuting);
	m_LeftStep.EnableWindow(!ThreadIsExecuting);
	m_StopStep.EnableWindow(!ThreadIsExecuting);
}

void CKMotionCNCDlg::OnUpdateRestart(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(CurrentLine[m_Thread]!=0 && !ThreadIsExecuting);
}

void CKMotionCNCDlg::OnUpdateSingleStep(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!ThreadIsExecuting);
}

int CKMotionCNCDlg::SetExecutionPoint(int line)
{
	CurrentLine[m_Thread] = line;
	return 0;
}

void CKMotionCNCDlg::OnGView() 
{
	CreateDlgOrBringToTop(IDD_GView,&TheFrame->GViewDlg);
}

void CKMotionCNCDlg::OnSimulate() 
{
	UpdateData();	
}

void CKMotionCNCDlg::OnShowMach() 
{
	UpdateData();	
}

void CKMotionCNCDlg::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	CString s;
	
	CDlgX::OnVScroll(nSBCode, nPos, pScrollBar);

	m_FeedRateValue = m_FeedSlider.GetPos();

	s.Format("%.2f",m_FeedRateValue);

	SetDlgItemText(IDC_FeedRateEdit,s);
	
	Interpreter.CoordMotion.SetFeedRateOverride(m_FeedRateValue);
}


void CKMotionCNCDlg::OnFeedRateApply() 
{
	if (!UpdateData()) return;

	m_FeedSlider.SetPos(m_FeedRateValue);

	Interpreter.CoordMotion.SetFeedRateOverride(m_FeedRateValue);
}


CKMotionCNCDlg::CKMotionCNCDlg(CWnd* pParent /*=NULL*/)
	: CDlgX(pParent)
{
	int i;

	ShuttingDownApplication=FALSE;
	m_ColorTraverse.Set(255,0,0);
	m_ColorFeed.Set(0,255,0);

	GreenBrush=NULL;

	GCodeMutex = new CMutex(FALSE,"GCodeInterpreter",NULL);
	for (i=0; i<N_USER_GCODE_FILES; i++)
	{
		ThreadHadError[i]=false;
		GCodeThreadActive[i]=false;
		CurrentLine[i]=0;
	}

	ThreadIsExecuting=false;

	m_ToolFile = _T("");
	m_SetupFile = _T("");
	m_GeoFile = _T("");
	m_BreakAngle = 30.0;
	m_CollinearTol = 0.0002;
	m_ReverseRZ = false;
	m_TPLookahead = 3.0;
	m_MaxAccelA = 0.01;
	m_MaxAccelX = 0.01;
	m_MaxAccelY = 0.01;
	m_MaxAccelZ = 0.01;
	m_MaxVelA = 0.1;
	m_MaxVelX = 0.1;
	m_MaxVelY = 0.1;
	m_MaxVelZ = 0.1;
	m_CountsPerInchA = 100.0;
	m_CountsPerInchX = 100.0;
	m_CountsPerInchY = 100.0;
	m_CountsPerInchZ = 100.0;
	m_Step0 = 0.0001;
	m_Step1 = 0.001;
	m_Step2 = 0.01;
	m_Step3 = 0.1;
	m_Step4 = 1;
	m_Step5 = 10;


	//{{AFX_DATA_INIT(CKMotionCNCDlg)
	m_Thread = -1;
	m_Simulate = FALSE;
	m_ShowMach = FALSE;
	m_FeedRateValue = 1.0;
	m_CommandString = _T("");
	m_StepSize = 0;
	//}}AFX_DATA_INIT
	

	for (i=0; i<N_CHANNELS; i++)
	{
		CS_axis[i]=-1;
		m_JogSpeed[i]=1;
	}


	if (LoadLibrary("SciLexer.DLL")==NULL)
	{
		MessageBox("The Scintilla DLL could not be loaded.",
		"Error loading Scintilla",
		MB_OK | MB_ICONERROR);
	}

	m_hAccelTable=LoadAccelerators(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDR_ACCELERATOR1));

	board=0;
	ReadStatus=true;
	CurAbsX=CurAbsY=CurAbsZ=CurAbsA=0;
	m_Joyvx = m_Joyvy = m_Joyvz = m_Joyva = 0.0;
	m_JoyMovedx = false;
	m_JoyMovedy = false;
	m_JoyMovedz = false;
	m_JoyMoveda = false;
	m_LastFixtureDisplayed=m_LastToolDisplayed=-1;
}

CKMotionCNCDlg::~CKMotionCNCDlg()
{
	if (m_GCodeTools)
		delete m_GCodeTools;

	if (GreenBrush) delete GreenBrush;

	delete GCodeMutex;
}



void CKMotionCNCDlg::OnDropdownCommand() 
{
	UpdateData(TRUE);
	m_Command.ResetContent();
	UpdateData(FALSE);
	
	SaveUserCommand=m_CommandString;
	SaveUserCommandVar=&m_CommandString;
	SaveUserCommandCombo=&m_Command;

	// add them in backwards skipping blank lines
	
	for (int i=0; i<NCOMMAND_HISTORY; i++)
		if (!CommandHistory[i].IsEmpty())
			m_Command.AddString(CommandHistory[i]);
}

void CKMotionCNCDlg::OnCloseupCommand() 
{
	int i = m_Command.GetCurSel();
	
	if (i!=-1) m_Command.GetLBText(i, SaveUserCommand);
	
	SetTimer(2,1,NULL);  // put the edit control how we wish after going idle
}






void CKMotionCNCDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDlgX::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CKMotionCNCDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDlgX::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CKMotionCNCDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}




void CKMotionCNCDlg::OnF1() 
{
	if (AfxMessageBox("ABORT?",MB_ICONQUESTION|MB_YESNO)==IDYES)
		OnEmergencyStop();
}


BOOL CKMotionCNCDlg::PreTranslateMessage(MSG* pMsg) 
{
	if (m_hAccelTable) 
	{
		if (::TranslateAccelerator(m_hWnd, m_hAccelTable, pMsg)) 
		{
			return(TRUE);
		}
	}
	return CDlgX::PreTranslateMessage(pMsg);
}


int CKMotionCNCDlg::DoJoyStick()
{
	JOYINFOEX ji;
	CCoordMotion *CM=&Interpreter.CoordMotion;
	unsigned long RtoUse, ZtoUse;
	static bool FirstEmergencyStop=true;
	static bool FirstSingleStep=true;
	static bool FirstHalt=true; 
	static bool FirstFeedRateHigh=true; 
	static bool FirstFeedRateLow=true; 
	static CString OrigFeedRate;

	ji.dwSize=sizeof(JOYINFOEX);
	ji.dwFlags=JOY_RETURNALL;


	MMRESULT result = joyGetPosEx(JOYSTICKID1,&ji); 

	if (result == JOYERR_NOERROR)
	{

		// POV full down causes emergency stop
		if (FirstEmergencyStop && ji.dwPOV != 0xffff)
		{
			FirstEmergencyStop=false;
			OnEmergencyStop();
		}

		if (ji.dwButtons &0x10) // slow mode ??
		{
			FirstHalt=false;
			OnHalt();
		}



		if (ji.dwButtons & 0x10)
			m_JogSpeedFactor=0.25f;
		else
			m_JogSpeedFactor=1.00f;


		if (FirstSingleStep && ji.dwButtons & 0x1)
		{
			FirstSingleStep=false;
			OnSingleStep();
		}

		if (!FirstFeedRateHigh && ((ji.dwButtons & 0x8)==0))
		{
			SetDlgItemText(IDC_FeedRateEdit,OrigFeedRate);
			PostMessage(WM_COMMAND,IDC_FeedRateApply);
			FirstFeedRateHigh=true;
		}
		else if (FirstFeedRateHigh && (ji.dwButtons & 0x8))
		{
			FirstFeedRateHigh=false;
			// remember what it was
			GetDlgItemText(IDC_FeedRateEdit,OrigFeedRate);
			SetDlgItemText(IDC_FeedRateEdit,"2.0");
			PostMessage(WM_COMMAND,IDC_FeedRateApply);
		}

		if (!FirstFeedRateLow && ((ji.dwButtons & 0x2)==0))
		{
			SetDlgItemText(IDC_FeedRateEdit,OrigFeedRate);
			PostMessage(WM_COMMAND,IDC_FeedRateApply);
			FirstFeedRateLow=true;
		}
		else if (FirstFeedRateLow && (ji.dwButtons & 0x2))
		{
			FirstFeedRateLow=false;
			// remember what it was
			GetDlgItemText(IDC_FeedRateEdit,OrigFeedRate);
			SetDlgItemText(IDC_FeedRateEdit,"0.5");
			PostMessage(WM_COMMAND,IDC_FeedRateApply);
		}

		if (ji.dwPOV == 0xffff && ji.dwButtons == 0)  // all buttons are completely released
		{
			FirstEmergencyStop=true;
			FirstSingleStep=true;
			FirstHalt=true;
		}

		if (m_ReverseRZ)
		{
			ZtoUse = ji.dwRpos;
			RtoUse = ji.dwZpos;
		}
		else
		{
			RtoUse = ji.dwRpos;
			ZtoUse = ji.dwZpos;
		}

		m_Joyvx = DoJoyAxis(0,       ji.dwXpos);
		m_Joyvy = DoJoyAxis(1,0xffff-ji.dwYpos);
		m_Joyvz = DoJoyAxis(2,0xffff-RtoUse   );
		m_Joyva = DoJoyAxis(3,       ZtoUse   );
	}
	else
	{
		// joystick not connected
		//
		// in case of loss of connection stop any jogs

		m_Joyvx = m_Joyvy = m_Joyvz = m_Joyva = 0.0;
	}


	if (m_Simulate)
	{
		CM->current_x += m_Joyvx * STATUS_TIME; //Sim for 0.1 sec
		CM->current_y += m_Joyvy * STATUS_TIME; 
		CM->current_z += m_Joyvz * STATUS_TIME; 
		CM->current_a += m_Joyva * STATUS_TIME;
	}
	else
	{
		ProcessChangeInJogVelocity();
	}

	return 0;
}

int CKMotionCNCDlg::ProcessChangeInJogVelocity()
{
	static bool DoAFinalMove = false;
	static bool WaitingForFinalMove = false;
	CCoordMotion *CM=&Interpreter.CoordMotion;
	double vx,vy,vz,va;

	if (DoAFinalMove)
	{
		// check if we came to a stop yet (either from Jog to stop, or from offset)

		CString response;
		if (TheFrame->KMotionDLL.WriteLineReadLine(board,"CheckDoneXYZA",response.GetBufferSetLength(MAX_LINE))) return 1;
		response.ReleaseBuffer();

		if (response=="0") return 0;  // exit if still stopping 

		if (!WaitingForFinalMove)
		{
			// do a final move to either where the axis was originally
			// or to where it currently is depending on whether that
			// axis was ever moved or not

			double x = m_JoyMovedx ? CurAbsX : m_Joyx0;
			double y = m_JoyMovedy ? CurAbsY : m_Joyy0;
			double z = m_JoyMovedz ? CurAbsZ : m_Joyz0;
			double a = m_JoyMoveda ? CurAbsA : m_Joya0;
		
			double Acts[MAX_ACTUATORS];

			CM->Kinematics->TransformCADtoActuators(x, y, z, a, Acts);

			for (int i=0; i<MAX_ACTUATORS; i++)
				if (DoActPosition(i,Acts[i])) return 1;

			m_JoyMovedx = false;
			m_JoyMovedy = false;
			m_JoyMovedz = false;
			m_JoyMoveda = false;

			WaitingForFinalMove = true;
			return 0;
		}

		// we are stopped, remember the starting position

		m_Joyx0 = CurAbsX;
		m_Joyy0 = CurAbsY;
		m_Joyz0 = CurAbsZ;
		m_Joya0 = CurAbsA;

		DoAFinalMove = WaitingForFinalMove = false;
	}


	vx = m_Joyvx;
	if (vx == 0.0) vx = m_Right2.m_RawVel;
	if (vx == 0.0) vx = m_Right.m_RawVel;
	if (vx == 0.0) vx = m_Left2.m_RawVel;
	if (vx == 0.0) vx = m_Left.m_RawVel;

	vy = m_Joyvy;
	if (vy == 0.0) vy = m_Up2.m_RawVel;
	if (vy == 0.0) vy = m_Up.m_RawVel;
	if (vy == 0.0) vy = m_Down2.m_RawVel;
	if (vy == 0.0) vy = m_Down.m_RawVel;

	vz = m_Joyvz;
	if (vz == 0.0) vz = m_Zplus2.m_RawVel;
	if (vz == 0.0) vz = m_Zplus.m_RawVel;
	if (vz == 0.0) vz = m_Zminus2.m_RawVel;
	if (vz == 0.0) vz = m_Zminus.m_RawVel;

	va = m_Joyva;
	if (va == 0.0) va = m_Aplus2.m_RawVel;
	if (va == 0.0) va = m_Aplus.m_RawVel;
	if (va == 0.0) va = m_Aminus2.m_RawVel;
	if (va == 0.0) va = m_Aminus.m_RawVel;


	// Check if we are to stop
	
	if (vx==0 && vy==0 && vz==0 && va==0)
	{
		// check if we had been moving

		if (m_JoyMovedx || m_JoyMovedy || m_JoyMovedz ||m_JoyMoveda)
		{
			for (int i=0; i<MAX_ACTUATORS; i++)
				if (DoActVelocity(i,0.0)) return 1;

			DoAFinalMove = true;
		}
		else
		{
			// whenever we are stopped, remember the starting position

			m_Joyx0 = CurAbsX;
			m_Joyy0 = CurAbsY;
			m_Joyz0 = CurAbsZ;
			m_Joya0 = CurAbsA;
			m_JoyMovedx = false;
			m_JoyMovedy = false;
			m_JoyMovedz = false;
			m_JoyMoveda = false;
		}
	}
	else
	{
		// no we are moving, keep track of which axis ever moved 

		if (vx != 0.0) m_JoyMovedx = true;
		if (vy != 0.0) m_JoyMovedy = true;
		if (vz != 0.0) m_JoyMovedz = true;
		if (va != 0.0) m_JoyMoveda = true;

		// if an axis was never moved since the last time we were still
		// then drive it back toward it's original coordinate at a rate
		// such that it should be there by the next timer

		if (!m_JoyMovedx)
			vx = (m_Joyx0 - CurAbsX)/STATUS_TIME;

		if (!m_JoyMovedy)
			vy = (m_Joyy0 - CurAbsY)/STATUS_TIME;

		if (!m_JoyMovedz)
			vz = (m_Joyz0 - CurAbsZ)/STATUS_TIME;

		if (!m_JoyMoveda)
			va = (m_Joya0 - CurAbsA)/STATUS_TIME;


		double Acts0[MAX_ACTUATORS];
		double Acts1[MAX_ACTUATORS];

		double x0 = CurAbsX;
		double y0 = CurAbsY;
		double z0 = CurAbsZ;
		double a0 = CurAbsA;

		double x1 = x0 + vx * STATUS_TIME;
		double y1 = y0 + vy * STATUS_TIME;
		double z1 = z0 + vz * STATUS_TIME;
		double a1 = a0 + va * STATUS_TIME;

		CM->Kinematics->TransformCADtoActuators(x0, y0, z0, a0, Acts0);
		CM->Kinematics->TransformCADtoActuators(x1, y1, z1, a1, Acts1);

		for (int i=0; i<MAX_ACTUATORS; i++)
			if (DoActVelocity(i,(Acts1[i]-Acts0[i])/STATUS_TIME)) return 1;
	}
	return 0;
}


// command an actuator to a specified velocity

int CKMotionCNCDlg::DoActVelocity(int i, double v)
{
	static double LastSpeed[4]={1e99,1e99,1e99,1e99};
	CString s;
	
	if (CS_axis[i]>=0)
	{
		// command a distance (jog) of 0.5 seconds at that speed
		// so in the case we loose communication it will still stop

		if (fabs(v) > 0) 
			s.Format("MoveRelAtVel%d=%f %f",CS_axis[i],v*0.5,fabs(v));
		else if (LastSpeed[i] != 0)
			s.Format("Jog%d=%f",CS_axis[i],v);

		if (TheFrame->KMotionDLL.WriteLine(board,s)) return 1;
	}
	LastSpeed[i]=v;
	
	return 0;
}


// command an actuator to stop

int CKMotionCNCDlg::StopAxis(int i)
{
	CString s;
	
	if (CS_axis[i]>=0)
	{
		s.Format("Jog%d=0",CS_axis[i]);

		if (TheFrame->KMotionDLL.WriteLine(board,s)) return 1;
	}
	return 0;
}

// command an actuator to a specified position

int CKMotionCNCDlg::DoActPosition(int i, double p)
{
	CString s;
	
	if (CS_axis[i]>=0)
	{
		// command a move to an abs position

		s.Format("Move%d=%f",CS_axis[i],p);
		if (TheFrame->KMotionDLL.WriteLine(board,s)) return 1;
	}
	
	return 0;
}



double CKMotionCNCDlg::DoJoyAxis(int axis, int joystick)
{
	double v;

	v = joystick-0x7fff;
	if (ThreadIsExecuting) v=0;
	if (fabs(v) < 1600) v=0;

	v *= m_JogSpeed[axis] * m_JogSpeedFactor / 32768.0;

	return v;
}




int CKMotionCNCDlg::GetStatus()
{
	int i,result,n;
	CString s;
	int *p=(int *)&MainStatus;


	// KMotion is available read the status
	s.Format("GetStatus");  
	if (TheFrame->KMotionDLL.WriteLine(board,s)) return 1;

	n=sizeof(MainStatus)/sizeof(int);

	s.Empty();

	for (i=0; i<n; i++)
	{
		if (s.IsEmpty())
		{
			if (TheFrame->KMotionDLL.ReadLineTimeOut(board, s.GetBuffer(257),1000))
			{
				return 1;
			}

			s.ReleaseBuffer();

			// change the CRLF at the to a space

			s.Delete(s.GetLength()-2,2);

			s += ' ';
		}

		// get a hex 32 bit int which may really be anything
		
		result = sscanf(s.GetBuffer(0),"%8X",p++);

		if (result!=1)
		{
			return 1;
		}

		if (s.GetLength() >=9)
		{
			s.Delete(0,9);
		}
		else
		{
			return 1;
		}

		// check if first word contains version

		if (i==0)
		{
			if (p[-1]>>16==0)
			{
				// probably old version of DSP Code

				// set version to something

				MainStatus.VersionAndSize=0;
				MainStatus.ThreadActive=0;

				p[0] = p[-1];
				p++;
				n=n-2;
			}
			else
			{
				// update number of words to read
				if (n!=(MainStatus.VersionAndSize & 0xffff))
					AfxMessageBox("Error Status Record Size",MB_ICONSTOP|MB_OK);
			}
		}
	}

	return 0;
}

int CKMotionCNCDlg::UpdateScreen(bool KMotionPresent)
{
	int result;
	CString s,response;

	if (KMotionPresent)
	{
		// first find out which axis is which

		if (TheFrame->KMotionDLL.WriteLineReadLine(board,"DefineCS",response.GetBufferSetLength(MAX_LINE))) return 1;
		response.ReleaseBuffer();
		result=sscanf(response, "%d%d%d%d",&CS_axis[0],&CS_axis[1],&CS_axis[2],&CS_axis[3]);
		if (result != 4)  return 1;
	}
	
	SetBigValues(&m_PosX, &m_PosY, &m_PosZ, &m_PosA, KMotionPresent);

	
	if (Interpreter.p_setup->distance_mode==MODE_ABSOLUTE)
		CheckRadioButton(IDC_Rel,IDC_Abs,IDC_Abs);
	else
		CheckRadioButton(IDC_Rel,IDC_Abs,IDC_Rel);

	if (Interpreter.p_setup->length_units==CANON_UNITS_INCHES)
		CheckRadioButton(IDC_mm,IDC_inch,IDC_inch);
	else if (Interpreter.p_setup->length_units==CANON_UNITS_MM)
		CheckRadioButton(IDC_mm,IDC_inch,IDC_mm);

	if (m_LastToolDisplayed != Interpreter.p_setup->tool_table_index)
	{
		m_LastToolDisplayed=Interpreter.p_setup->tool_table_index;
		m_tool.SetCurSel(m_LastToolDisplayed-1);
	}

	if (m_LastFixtureDisplayed != Interpreter.p_setup->origin_index)
	{
		m_LastFixtureDisplayed=Interpreter.p_setup->origin_index;
		m_FixtureOffset.SetCurSel(m_LastFixtureDisplayed-1);
	}

	return 0;
}


void CKMotionCNCDlg::SetBigValueColor(CDisplay *Disp,int axis, bool KMotionPresent)
{
	if (m_Simulate)
		Disp->SetTextColor(0xFFFFFF);
	else if (KMotionPresent && (MainStatus.Enables & (1<<CS_axis[axis])) && CS_axis[axis] >= 0)
	{
		if (m_ShowMach)
			Disp->SetTextColor(0x0080FF);
		else
			Disp->SetTextColor(0x00FF00);
	}
	else
		Disp->SetTextColor(0x00FFFF);
}


void CKMotionCNCDlg::SetBigValues(CDisplay *Disp0, CDisplay *Disp1, CDisplay *Disp2, CDisplay *Disp3, bool KMotionPresent)
{
	double x,y,z,a;
	CString s;

	SetBigValueColor(Disp0,0,KMotionPresent);
	SetBigValueColor(Disp1,1,KMotionPresent);
	SetBigValueColor(Disp2,2,KMotionPresent);
	SetBigValueColor(Disp3,3,KMotionPresent);

	if (KMotionPresent && !m_Simulate)
	{
		if (Interpreter.CoordMotion.ReadCurAbsPosition(&x,&y,&z,&a)) return;
		CurAbsX = x;
		CurAbsY = y;
		CurAbsZ = z;
		CurAbsA = a;
	}
	else
	{
		x = Interpreter.CoordMotion.current_x;
		y = Interpreter.CoordMotion.current_y;
		z = Interpreter.CoordMotion.current_z;
		a = Interpreter.CoordMotion.current_a;
	}

	// convert absolute machine's position in inches to 
	// the Interpreter's position that may include offsets
	// and metric units

	if (m_ShowMach)
		Interpreter.CoordMotion.ConvertAbsoluteToMachine(x,y,z,a,&x,&y,&z,&a);
	else
		Interpreter.CoordMotion.ConvertAbsoluteToInterpreterCoord(x,y,z,a,&x,&y,&z,&a);

	s.Format(" X:%10.4f ",x);
	KillMinusZero(s);
	Disp0->SetText(s);

	s.Format(" Y:%10.4f ",y);
	KillMinusZero(s);
	Disp1->SetText(s);

	s.Format(" Z:%10.4f ",z);
	KillMinusZero(s);
	Disp2->SetText(s);

	s.Format(" A:%10.4f ",a);
	KillMinusZero(s);
	Disp3->SetText(s);
}

// format shows very small negative numbers as -0
// which looks bad, so just change to zero

void CKMotionCNCDlg::KillMinusZero(CString &s)
{
	int i=3;
	int n=s.GetLength();

	while (s.GetAt(i)==' ' && i<n) i++;  // skip over leading zeros
	
	if (s.GetAt(i) != '-') return;  // if no minus sign, no problen

	int k=i++; // remember where minus sign is

	while (i<n)
	{
		if (s.GetAt(i)!='.' && s.GetAt(i)!='0' && s.GetAt(i)!=' ') return;
		i++;  
	}
	s.SetAt(k,' ');
}




void CKMotionCNCDlg::OnEmergencyStop() 
{
	CString s;
	int i;

	for (i=0;i<N_USER_THREADS;i++)         // kill all user programs
	{

		s.Format("Kill %d", i+1);

		if (TheFrame->KMotionDLL.WriteLine(board, s)) return;
	}

	Interpreter.Halt();
	
	Interpreter.Abort();

	for (i=0;i<N_CHANNELS;i++)             // disable all servo channels
	{
		s.Format("DISABLEAXIS%d",i);
		if (TheFrame->KMotionDLL.WriteLine(board,s)) return;
	}
}


int CKMotionCNCDlg::SetAxis(CString G, double *LastHardwarePos, double *CurInterpPos, double SetPos, double Offsets)
{
	if (m_Simulate)
	{
		*CurInterpPos = SetPos;												// set the Interpreter's relative current position
		*LastHardwarePos =  Interpreter.UserUnitsToInches(SetPos+Offsets);  // adjust the hardware absolute position to match
	}
	else
	{
		CString Number;
		Number.Format("%.15f",SetPos);
		while (Number.GetAt(Number.GetLength()-1) == '0') Number.Delete(Number.GetLength()-1);  // remove trailing zeros
		DoGCodeLine("G92 " + G + Number);
	}
	return 0;
}


void CKMotionCNCDlg::OnZeroAll() 
{
	if (AfxMessageBox("Zero All Axes?",MB_YESNO|MB_ICONQUESTION) == IDYES)
	{
		if (SetAxis("X",&Interpreter.CoordMotion.current_x, &Interpreter.p_setup->current_x, 0.0, Interpreter.p_setup->axis_offset_x + Interpreter.p_setup->origin_offset_x)) return;
		if (SetAxis("Y",&Interpreter.CoordMotion.current_y, &Interpreter.p_setup->current_y, 0.0, Interpreter.p_setup->axis_offset_y + Interpreter.p_setup->origin_offset_y)) return;
		if (SetAxis("Z",&Interpreter.CoordMotion.current_z, &Interpreter.p_setup->current_z, 0.0, Interpreter.p_setup->axis_offset_z + Interpreter.p_setup->origin_offset_z)) return;
		if (SetAxis("A",&Interpreter.CoordMotion.current_a, &Interpreter.p_setup->AA_current, 0.0, Interpreter.p_setup->AA_axis_offset + Interpreter.p_setup->AA_origin_offset)) return;
	}
}

void CKMotionCNCDlg::OnZeroX() 
{
	SetAxis("X",&Interpreter.CoordMotion.current_x, &Interpreter.p_setup->current_x, 0.0, Interpreter.p_setup->axis_offset_x + Interpreter.p_setup->origin_offset_x);
}

void CKMotionCNCDlg::OnZeroY() 
{
	SetAxis("Y",&Interpreter.CoordMotion.current_y, &Interpreter.p_setup->current_y, 0.0, Interpreter.p_setup->axis_offset_y + Interpreter.p_setup->origin_offset_y);
}

void CKMotionCNCDlg::OnZeroZ() 
{
	SetAxis("Z",&Interpreter.CoordMotion.current_z, &Interpreter.p_setup->current_z, 0.0, Interpreter.p_setup->axis_offset_z + Interpreter.p_setup->origin_offset_z);
}

void CKMotionCNCDlg::OnZeroA() 
{
	SetAxis("A",&Interpreter.CoordMotion.current_a, &Interpreter.p_setup->AA_current, 0.0, Interpreter.p_setup->AA_axis_offset + Interpreter.p_setup->AA_origin_offset);
}

void CKMotionCNCDlg::MakeSureFileIsntReadOnly(CString FN)
{
	FN=TheFrame->MainPathRoot+FN;
	if (_access(FN,00)==0)						// check if file exists
		if (!_access(FN,06)==0)					// check if doesn't have r/w
			_chmod(FN,_S_IREAD | _S_IWRITE);	// make it r/w
}


void CKMotionCNCDlg::OnDropdownfixture() 
{
	// TODO: Add your control notification handler code here
	
}

void CKMotionCNCDlg::OnCloseupfixture() 
{
	int fixture = m_FixtureOffset.GetCurSel()+1;
	m_LastFixtureDisplayed = fixture;
	Interpreter.ChangeFixtureNumber(fixture);
}

void CKMotionCNCDlg::OnClose() 
{
	char buf[MAX_PATH];

	DWORD t0 = timeGetTime();

	ShuttingDownApplication=TRUE;

	// Flag other process thread to terminate

	while (ThreadIsExecuting && timeGetTime() < t0+3000)
	{
		Interpreter.Abort();
	}


	if (PersistRestored ||  // check if valid parameters were loaded on startup
			AfxMessageBox("Configuration File was not properly loaded on startup.\r\r"
			              "Would you like to save the current configuration?",MB_YESNO|MB_ICONINFORMATION)
					  == IDYES)

	{
		CString File = TheFrame->MainPathRoot + PERSISTANT_FILE;
		
		FILE *f=fopen(File.GetBuffer(0),"wt");
		
		if (f)
		{
			fprintf(f,"Version 3\n");

			// be nice and remember what directory we were last time

			GetCurrentDirectory(MAX_PATH,buf);
			fprintf(f,"%s\n",buf);

			// sequence through all the dialogs and give them
			// a chance to save their state

			SaveOnExit(f);
			TheFrame->GViewDlg.SaveOnExit(f);

			fclose(f);
		}
	}

	CDlgX::OnClose();

	AfxGetApp()->GetMainWnd()->PostMessage(WM_CLOSE);
}

void CKMotionCNCDlg::FillComboWithCount(int i0, int i1, CComboBox *Box)
{
	CString s;

	Box->ResetContent();

	for (int i=i0; i<=i1; i++)
	{
		s.Format("%d",i);
		Box->AddString(s);
	}
}

void CKMotionCNCDlg::FillComboWithCountFixture(int i0, int i1, CComboBox *Box)
{
	CString s;

	Box->ResetContent();

	for (int i=i0; i<=i1; i++)
	{
		if (i<7)
			s.Format("%d - G%d",i,53+i);
		else
			s.Format("%d - G%.1f",i,59+0.1*i);

		Box->AddString(s);
	}
}

void CKMotionCNCDlg::OnSend() 
{
	if (!UpdateData()) return;

	if (DoGCodeLine(m_CommandString)) return;

	// Save last few enterd commands

	// first check for a duplicate

	int i;
	for (i=0; i<NCOMMAND_HISTORY-1; i++)
		if (CommandHistory[i] == m_CommandString) break;

	// push the others down over where it is (or to the last)

	for (int k=i; k>0; k--)
		CommandHistory[k] = CommandHistory[k-1];

	CommandHistory[0] = m_CommandString;
}

int CKMotionCNCDlg::DoGCodeLine(CString G) 
{
	CString File = TheFrame->MainPathRoot + TEMP_GCODE_FILE;


	int i=0;

	while (ThreadIsExecuting)
	{
		Sleep(10);
		if (i++ > 1000)
		{
			AfxMessageBox("Error - Interpreter Busy");
			return 1;
		}
	}
	
	FILE *f=fopen(File,"wt");
	
	if (!f)
	{
		AfxMessageBox("Unable to open Temporary File:\r\r" + File);
		return 1;
	}

	fwrite(G + '\n',G.GetLength()+1,1,f);

	fclose(f);

	m_ThreadThatWasLaunched=-1;  // special code for no file
	
	if (LaunchExecution(File,0,0)) return 1;

	return 0;
}


void CKMotionCNCDlg::CreateDlgOrBringToTop(UINT ID, CDialog *Dlg)
{
	int result;

    // create the dialog, or if it already exists, bring to top

	if (Dlg->m_hWnd)
	{
		Dlg->BringWindowToTop();
		// restore the window if it is minimized
		WINDOWPLACEMENT wndplace;
		if (Dlg->GetWindowPlacement(&wndplace))
		{
			if (SW_SHOWMINIMIZED==wndplace.showCmd)
				Dlg->ShowWindow(SW_RESTORE);
		}
	}
	else
		result = Dlg->Create(ID,TheFrame);

}


int CKMotionCNCDlg::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	// Save for everybody what directory we are installed in
	CString Param1;
	int nParams,NewBoard;
	LPWSTR *CL= CommandLineToArgvW(GetCommandLineW(),&nParams);
	TheFrame->MainPath = CL[0];
	if (nParams>1)
	{
		Param1=CL[1];

		if (Param1.Left(2) == "0x" || Param1.Left(2) == "0X")
			Param1.Delete(0,2);
		
		sscanf(Param1,"%x",&NewBoard);

		board=NewBoard;
	}
	GlobalFree(CL);


	TheFrame->MainPath.Replace("\"","");  // remove quotes
	TheFrame->MainPath.TrimRight();
	TheFrame->MainPath.TrimLeft();

	int LastSlash=TheFrame->MainPath.ReverseFind('\\');
	TheFrame->MainPath=TheFrame->MainPath.Left(LastSlash);


	// Check if we are running from the debug directory
	// if we are, then strip it off

	if (TheFrame->MainPath.Right(6).CompareNoCase("\\debug") == 0)
	{
		TheFrame->MainPath = TheFrame->MainPath.Left(TheFrame->MainPath.GetLength()-6);
	}

	// Check if we are running from the release directory
	// if we are, then strip it off

	if (TheFrame->MainPath.Right(8).CompareNoCase("\\release") == 0)
	{
		TheFrame->MainPath = TheFrame->MainPath.Left(TheFrame->MainPath.GetLength()-8);
	}

	// Now set the root install directory

	if (TheFrame->MainPath.Right(8).CompareNoCase("\\KMotion") == 0)
	{
		TheFrame->MainPathRoot = TheFrame->MainPath.Left(TheFrame->MainPath.GetLength()-8);
	}

	MakeSureFileIsntReadOnly("\\KMotion\\Data\\GCodeConfigCNC.txt");
	MakeSureFileIsntReadOnly("\\KMotion\\Data\\GFilesCNC.txt");
	MakeSureFileIsntReadOnly("\\KMotion\\Data\\persistCNC.ini");
	

	// be nice and put the current directory back to where
	// it was last time, also all the window positions 

	CString File = TheFrame->MainPathRoot + PERSISTANT_FILE;
	
	FILE *f=fopen(File,"rt");
	
	if (f)
	{
		CString Version;
		fgets(Version.GetBufferSetLength(100),100,f);
		Version.ReleaseBuffer();

		if (Version=="Version 3\n")  // don't attempt to read if incompatable
		{
			char buf[MAX_PATH];
		
			fgets(buf,MAX_PATH,f);
			buf[strlen(buf)-1]=0;
			SetCurrentDirectory(buf);

			//restore the state

			RestoreOnStart(f);
			TheFrame->GViewDlg.RestoreOnStart(f);
		}

		fclose(f);
		PersistRestored=true;
	}
	else
	{
		if (AfxMessageBox("Previous Configuration File:\r\r" + File +
			          "\r\rcould not be read.  Continuing will cause a loss of all\r"
					  "settings.  Are you sure you would like to continue?",MB_YESNO|MB_ICONSTOP)
					  != IDYES)
		exit(0);
		PersistRestored=false;
	}



	if (CDlgX::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// TODO: Add your specialized creation code here
	
	return 0;
}


void CKMotionCNCDlg::OnShowWindow(BOOL bShow, UINT nStatus) 
{
	if (!InitDialogComplete)
	{
		InitDialogComplete=TRUE;
		SetWindowPos(NULL,LastMoveX,LastMoveY,0,0,SWP_NOZORDER|SWP_NOSIZE);
	}
	CDlgX::OnShowWindow(bShow, nStatus);
}





void CKMotionCNCDlg::OnBut0() 
{
	Interpreter.InvokeAction(11,FALSE);
}

void CKMotionCNCDlg::OnBut1() 
{
	Interpreter.InvokeAction(12,FALSE);
}

void CKMotionCNCDlg::OnBut2() 
{
	Interpreter.InvokeAction(13,FALSE);
}

void CKMotionCNCDlg::OnBut3() 
{
	Interpreter.InvokeAction(14,FALSE);
}

void CKMotionCNCDlg::OnBut4() 
{
	Interpreter.InvokeAction(15,FALSE);
}

void CKMotionCNCDlg::SetUserButtons()
{
	SetAUserButton(IDC_But0,m_Button0);
	SetAUserButton(IDC_But1,m_Button1);
	SetAUserButton(IDC_But2,m_Button2);
	SetAUserButton(IDC_But3,m_Button3);
	SetAUserButton(IDC_But4,m_Button4);
}


void CKMotionCNCDlg::SetAUserButton(int ID, CString s)
{
	if (s.IsEmpty())
		GetDlgItem(ID)->ShowWindow(SW_HIDE);
	else
		GetDlgItem(ID)->ShowWindow(SW_SHOW);

	SetDlgItemText(ID,s);
}

void CKMotionCNCDlg::OnMeasure() 
{
	Interpreter.CoordMotion.MeasurePointAppendToFile(TheFrame->MainPathRoot + "\\KMotion\\Data\\Measurements.txt");
}

void CKMotionCNCDlg::OnStep0() 
{
	UpdateData();
}

void CKMotionCNCDlg::OnStep1() 
{
	UpdateData();
}

void CKMotionCNCDlg::OnStep2() 
{
	UpdateData();
}

void CKMotionCNCDlg::OnStep3() 
{
	UpdateData();
}

void CKMotionCNCDlg::OnStep4() 
{
	UpdateData();
}

void CKMotionCNCDlg::OnStep5() 
{
	UpdateData();
}

void CKMotionCNCDlg::OnSetX() 
{
	static CSetValue SetDlg;

	if (SetDlg.DoModal() == IDOK)
	{
		SetAxis("X",&Interpreter.CoordMotion.current_x, &Interpreter.p_setup->current_x, SetDlg.m_Value, Interpreter.p_setup->axis_offset_x + Interpreter.p_setup->origin_offset_x);
	}
}

void CKMotionCNCDlg::OnSetY() 
{
	static CSetValue SetDlg;

	if (SetDlg.DoModal() == IDOK)
	{
		SetAxis("Y",&Interpreter.CoordMotion.current_y, &Interpreter.p_setup->current_y, SetDlg.m_Value, Interpreter.p_setup->axis_offset_y + Interpreter.p_setup->origin_offset_y);
	}
}

void CKMotionCNCDlg::OnSetZ() 
{
	static CSetValue SetDlg;

	if (SetDlg.DoModal() == IDOK)
	{
		SetAxis("Z",&Interpreter.CoordMotion.current_z, &Interpreter.p_setup->current_z, SetDlg.m_Value, Interpreter.p_setup->axis_offset_z + Interpreter.p_setup->origin_offset_z);
	}
}

void CKMotionCNCDlg::OnSetA() 
{
	static CSetValue SetDlg;

	if (SetDlg.DoModal() == IDOK)
	{
		SetAxis("A",&Interpreter.CoordMotion.current_a, &Interpreter.p_setup->AA_current, SetDlg.m_Value, Interpreter.p_setup->AA_axis_offset + Interpreter.p_setup->AA_origin_offset);
	}
}

void CKMotionCNCDlg::SetStepSizes()
{
	SetStepText(5,m_Step5,IDC_Step5);
	SetStepText(4,m_Step4,IDC_Step4);
	SetStepText(3,m_Step3,IDC_Step3);
	SetStepText(2,m_Step2,IDC_Step2);
	SetStepText(1,m_Step1,IDC_Step1);
	SetStepText(0,m_Step0,IDC_Step0);
	UpdateData(false);
}

void CKMotionCNCDlg::SetStepText(int i, double v, int ID)
{
	if (v != 0)
	{
		CString s;
		s.Format("%f",v);
		while (s.GetAt(s.GetLength()-1) == '0') s.Delete(s.GetLength()-1);  // remove trailing zeros
		while (s.GetAt(s.GetLength()-1) == '.') s.Delete(s.GetLength()-1);  // remove trailing decimals
		SetDlgItemText(ID,s);
		GetDlgItem(ID)->SetWindowText(s);
		GetDlgItem(ID)->ShowWindow(SW_SHOW);
	}
	else
	{
		GetDlgItem(ID)->ShowWindow(SW_HIDE);
		if (i == m_StepSize && m_StepSize != 0) m_StepSize--;
	}

}

void CKMotionCNCDlg::OnStopStep() 
{
	for (int i=0; i<MAX_ACTUATORS; i++)
		StopAxis(i);
}

void CKMotionCNCDlg::Onmm() 
{
	DoGCodeLine("G21");
}

void CKMotionCNCDlg::Oninch() 
{
	DoGCodeLine("G20");
}

void CKMotionCNCDlg::OnAbs() 
{
	DoGCodeLine("G90");
}

void CKMotionCNCDlg::OnRel() 
{
	DoGCodeLine("G91");
}
